package com.biz.crm.mdm.cusorg.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.cusorg.MdmCusOrgFeign;
import com.biz.crm.nebular.mdm.cusorg.CusOrgVo;
import com.biz.crm.nebular.mdm.cusorg.MdmCustomerOrgSelectRespVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/8/26 15:40
 **/
@Slf4j
@Component
public class MdmCusOrgFeignImpl extends BaseAbstract implements FallbackFactory<MdmCusOrgFeign> {
    @Override
    public MdmCusOrgFeign create(Throwable throwable) {
        log.error("进入熔断", throwable);
        return new MdmCusOrgFeign() {
            @Override
            public Result<Object> add(CusOrgVo cusOrgVo) {
                return doBack();
            }

            @Override
            public Result<CusOrgVo> query(String id, String customerOrgCode) {
                return doBack();
            }

            @Override
            public Result<Object> edit(CusOrgVo cusOrgVo) {
                return doBack();
            }

            @Override
            public Result<PageResult<CusOrgVo>> list(CusOrgVo cusOrgVo) {
                return doBack();
            }

            @Override
            public Result<Object> enAbleBatch(List<String> ids) {
                return doBack();
            }

            @Override
            public Result<Object> disAbleBatch(List<String> ids) {
                return doBack();
            }

            @Override
            public Result<Object> delBatch(List<String> ids) {
                return doBack();
            }

            @Override
            public Result<List<MdmCustomerOrgSelectRespVo>> customerOrgSelect(CusOrgVo cusOrgVo) {
                return doBack();
            }

            @Override
            public Result<Object> setUpRuleCode() {
                return doBack();
            }

            @Override
            public Result<List<CusOrgVo>> findList(CusOrgVo cusOrgVo) {
                return doBack();
            }
        };
    }
}
