package com.biz.crm.mdm.customer;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.customer.MdmCustomerContactReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerContactRespVo;
import com.biz.crm.mdm.customer.impl.MdmCustomerContactFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * feign接口
 *
 * @author zxw
 * @date 2020-09-02 14:10:26
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "MdmCustomerContactFeign",name="crm-mdm",path = "mdm",fallback = MdmCustomerContactFeignImpl.class)
public interface MdmCustomerContactFeign {

    /**
     * 列表
     */
    @PostMapping("/mdmcustomercontact/list")
    Result<PageResult<MdmCustomerContactRespVo>> list(@RequestBody MdmCustomerContactReqVo mdmCustomerContactReqVo);

    /**
     * 查询
     */
    @PostMapping("/mdmcustomercontact/query")
    Result query(@RequestBody MdmCustomerContactReqVo mdmCustomerContactReqVo);

    /**
     * 新增
     */
    @PostMapping("/mdmcustomercontact/save")
    Result save(@RequestBody MdmCustomerContactReqVo mdmCustomerContactReqVo);

    /**
     * 更新
     */
    @PostMapping("/mdmcustomercontact/update")
    Result update(@RequestBody MdmCustomerContactReqVo mdmCustomerContactReqVo);

    /**
     * 删除
     */
    @PostMapping("/mdmcustomercontact/delete")
    Result delete(@RequestBody MdmCustomerContactReqVo mdmCustomerContactReqVo);

    /**
     * 启用
     */
    @PostMapping("/mdmcustomercontact/enable")
    Result enable(@RequestBody MdmCustomerContactReqVo mdmCustomerContactReqVo);

    /**
     * 禁用
     */
    @PostMapping("/mdmcustomercontact/disable")
    Result disable(@RequestBody  MdmCustomerContactReqVo mdmCustomerContactReqVo);
}
