package com.biz.crm.mdm.customer;

import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.customer.impl.MdmCustomerDockingFeignImpl;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDockingReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDockingRespVo;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * feign接口
 *
 * @author zxw
 * @date 2020-09-02 14:10:25
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "MdmCustomerDockingFeign",name="crm-mdm",path = "mdm",fallback = MdmCustomerDockingFeignImpl.class)
public interface MdmCustomerDockingFeign {

    /**
     * 列表
     */
    @PostMapping("/mdmcustomerdocking/list")
    Result<PageResult<MdmCustomerDockingRespVo>> list(@RequestBody MdmCustomerDockingReqVo mdmCustomerDockingReqVo);

    /**
     * 查询客户对接人下拉框
     */
    @PostMapping("/mdmcustomerdocking/selectList")
    Result<List<MdmCustomerDockingRespVo>> selectList(@RequestBody MdmCustomerDockingReqVo mdmCustomerDockingReqVo);

    /**
     * 查询
     */
    @PostMapping("/mdmcustomerdocking/query")
    Result query(@RequestBody MdmCustomerDockingReqVo mdmCustomerDockingReqVo);

    /**
     * 新增
     */
    @PostMapping("/mdmcustomerdocking/save")
    Result save(@RequestBody MdmCustomerDockingReqVo mdmCustomerDockingReqVo);

    /**
     * 更新
     */
    @PostMapping("/mdmcustomerdocking/update")
    Result update(@RequestBody MdmCustomerDockingReqVo mdmCustomerDockingReqVo);

    /**
     * 删除
     */
    @PostMapping("/mdmcustomerdocking/delete")
    Result delete(@RequestBody MdmCustomerDockingReqVo mdmCustomerDockingReqVo);

    /**
     * 启用
     */
    @PostMapping("/mdmcustomerdocking/enable")
    Result enable(@RequestBody MdmCustomerDockingReqVo mdmCustomerDockingReqVo);

    /**
     * 禁用
     */
    @PostMapping("/mdmcustomerdocking/disable")
    Result disable(@RequestBody  MdmCustomerDockingReqVo mdmCustomerDockingReqVo);
}
