package com.biz.crm.mdm.org.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.nebular.mdm.common.BaseTreeRespVo;
import com.biz.crm.nebular.mdm.org.req.BaseOrgTreeReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgSearchReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgTreeRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgWithPositionRespVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 组织表feign接口熔断类
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@Slf4j
@Component
public class MdmOrgFeignImpl extends BaseAbstract implements FallbackFactory<MdmOrgFeign> {

    @Override
    public MdmOrgFeign create(Throwable throwable) {
        log.error("进入熔断", throwable);
        return new MdmOrgFeign() {
//            /**
//             * 列表
//             */
//            @Override
//            public Result<PageResult<MdmOrgRespVo>> list(MdmOrgReqVo mdmOrgReqVo) {
//                doBack();
//                PageResult<MdmOrgRespVo> build = PageResult.<MdmOrgRespVo>builder()
//                        .data(new ArrayList<>())
//                        .count(0L)
//                        .build();
//                return Result.ok(build);
//            }
//
//            /**
//             * 查询
//             */
//            @Override
//            public Result<MdmOrgRespVo> query(MdmOrgReqVo mdmOrgReqVo) {
//                return doBack();
//            }
//
//            /**
//             * 新增
//             */
//            @Override
//            public Result save(MdmOrgReqVo mdmOrgReqVo) {
//                return doBack();
//            }
//
//            /**
//             * 更新
//             */
//            @Override
//            public Result update(MdmOrgReqVo mdmOrgReqVo) {
//                return doBack();
//            }
//
//            /**
//             * 删除
//             */
//            @Override
//            public Result delete(MdmOrgReqVo mdmOrgReqVo) {
//                return doBack();
//            }
//
//            /**
//             * 启用
//             */
//            @Override
//            public Result enable(MdmOrgReqVo mdmOrgReqVo) {
//                return doBack();
//            }
//
//            /**
//             * 禁用
//             */
//            @Override
//            public Result disable(MdmOrgReqVo mdmOrgReqVo) {
//                return doBack();
//            }

            @Override
            public Result<MdmOrgRespVo> detail(String id, String orgCode) {
                return doBack();
            }

            @Override
            public Result<List<MdmOrgRespVo>> detailBatchByIds(List<String> ids) {
                return doBack();
            }

            @Override
            public Result<List<MdmOrgRespVo>> detailBatchByOrgCodeList(List<String> orgCodeList) {
                return doBack();
            }

            @Override
            public Result<List<MdmOrgRespVo>> findOrgAndChildrenList(MdmOrgSearchReqVo reqVo) {
                return doBack();
            }

            @Override
            public Result<List<MdmOrgRespVo>> findAllChildrenOrgList(MdmOrgReqVo mdmOrgReqVo) {
                return doBack();
            }

            @Override
            public Result<MdmOrgRespVo> detail(String orgCode) {
                return doBack();
            }

            @Override
            public Result<List<MdmOrgRespVo>> findSingleChildrenOrgList(MdmOrgReqVo mdmOrgReqVo) {
                return doBack();
            }

            @Override
            public Result<List<MdmOrgRespVo>> findAllParentOrgList(MdmOrgReqVo mdmOrgReqVo) {
                return doBack();
            }

            @Override
            public Result<MdmOrgRespVo> findSingleParentOrg(MdmOrgReqVo mdmOrgReqVo) {
                return doBack();
            }

            @Override
            public Result<MdmOrgRespVo> getParentOrg(String id, String orgCode) {
                return doBack();
            }

            @Override
            public Result resetRuleCode() {
                return doBack();
            }

            @Override
            public Result<List<MdmOrgWithPositionRespVo>> findOrgWithAllPositionList(List<String> orgCodeList) {
                return doBack();
            }

            @Override
            public Result<List<MdmOrgWithPositionRespVo>> findOrgWithSinglePositionList(List<String> orgCodeList) {
                return doBack();
            }

            @Override
            public Result<List<MdmOrgRespVo>> listCondition(MdmOrgReqVo reqVo) {
                return doBack();
            }

            @Override
            public Result<List<MdmOrgRespVo>> findOrgList(MdmOrgReqVo reqVo) {
                return doBack();
            }

            @Override
            public Result<List<MdmOrgTreeRespVo>> getOrgTree() {
                return doBack();
            }

            @Override
            public Result<List<String>> findAllParentOrgCodeExcludeSelf(List<String> orgCodeList) {
                return doBack();
            }

            @Override
            public Result<List<MdmOrgTreeRespVo>> orgSearchTree(MdmOrgReqVo mdmOrgReqVo) {
                return doBack();
            }

            /**
             * 查询分页列表
             * @param mdmOrgReqVo
             * @return
             */
            @Override
            public Result<PageResult<MdmOrgRespVo>> pageList(MdmOrgReqVo mdmOrgReqVo) {
                return doBack();
            }

            @Override
            public Result<PageResult<MdmOrgRespVo>> findAllPage(MdmOrgReqVo mdmOrgReqVo) {
                return doBack();
            }

            @Override
            public Result<List<MdmOrgRespVo>> getAll() {
                return doBack();
            }

            @Override
            public Result<List<BaseTreeRespVo>> orgTree(BaseOrgTreeReqVo reqVo) {
                return doBack();
            }
        };
    }
}
