package com.biz.crm.mdm.permission.impl;


import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.permission.MdmListConfigFeign;
import com.biz.crm.nebular.mdm.permission.MdmListConfigReqVo;
import com.biz.crm.nebular.mdm.permission.MdmListConfigRespVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * feign接口熔断类
 *
 * @author zxw
 * @date 2020-10-26 10:42:33
 */
@Slf4j
@Component
public class MdmListConfigFeignImpl extends BaseAbstract implements FallbackFactory<MdmListConfigFeign> {

    @Override
    public MdmListConfigFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new MdmListConfigFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<MdmListConfigRespVo>> list(MdmListConfigReqVo mdmListConfigReqVo) {
                doBack();
                PageResult<MdmListConfigRespVo> build = PageResult.<MdmListConfigRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<MdmListConfigRespVo> query(MdmListConfigReqVo mdmListConfigReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(MdmListConfigReqVo mdmListConfigReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(MdmListConfigReqVo mdmListConfigReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(MdmListConfigReqVo mdmListConfigReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(MdmListConfigReqVo mdmListConfigReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(MdmListConfigReqVo mdmListConfigReqVo) {
                return doBack();
            }
        };
    }
}
