package com.biz.crm.mdm.position.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.mdm.position.MdmPositionRedisFeign;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionParentChildrenRedisVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRedisVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionReloadRedisVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 职位表feign接口熔断类
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@Slf4j
@Component
public class MdmPositionRedisFeignImpl extends BaseAbstract implements FallbackFactory<MdmPositionRedisFeign> {

    @Override
    public MdmPositionRedisFeign create(Throwable throwable) {
        log.error("进入熔断", throwable);
        return new MdmPositionRedisFeign() {

            @Override
            public Result<List<MdmPositionRedisVo>> findRedisListByPositionCodeList(List<String> orgCodeList) {
                return doBack();
            }

            @Override
            public Result<List<MdmPositionParentChildrenRedisVo>> findRedisPositionParentListByCodeList(List<String> orgCodeList) {
                return doBack();
            }

            @Override
            public Result<List<MdmPositionParentChildrenRedisVo>> findRedisPositionChildrenListByCodeList(List<String> orgCodeList) {
                return doBack();
            }

            @Override
            public Result<List<MdmPositionReloadRedisVo>> findRedisReloadList() {
                return doBack();
            }

        };
    }
}
