package com.biz.crm.mdm.priceconditiongroup;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceConditionGroupRelFieldRespVo;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceConditionGroupRelFieldReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.mdm.priceconditiongroup.impl.MdmPriceConditionGroupRelFieldFeignImpl;

/**
 * 条件字段分类和字段的关系表 feign接口
 *
 * @author huanglong
 * @date 2020-10-14 17:21:40
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "MdmPriceConditionGroupRelFieldFeign",name="crm-mdm",path = "mdm",fallbackFactory = MdmPriceConditionGroupRelFieldFeignImpl.class)
public interface MdmPriceConditionGroupRelFieldFeign {

    /**
     * 列表
     */
    @PostMapping("/mdmpriceconditiongrouprelfield/list")
    Result<PageResult<MdmPriceConditionGroupRelFieldRespVo>> list(@RequestBody MdmPriceConditionGroupRelFieldReqVo mdmPriceConditionGroupRelFieldReqVo);

    /**
     * 查询
     */
    @PostMapping("/mdmpriceconditiongrouprelfield/query")
    Result<MdmPriceConditionGroupRelFieldRespVo> query(@RequestBody MdmPriceConditionGroupRelFieldReqVo mdmPriceConditionGroupRelFieldReqVo);

    /**
     * 新增
     */
    @PostMapping("/mdmpriceconditiongrouprelfield/save")
    Result save(@RequestBody MdmPriceConditionGroupRelFieldReqVo mdmPriceConditionGroupRelFieldReqVo);

    /**
     * 更新
     */
    @PostMapping("/mdmpriceconditiongrouprelfield/update")
    Result update(@RequestBody MdmPriceConditionGroupRelFieldReqVo mdmPriceConditionGroupRelFieldReqVo);

    /**
     * 删除
     */
    @PostMapping("/mdmpriceconditiongrouprelfield/delete")
    Result delete(@RequestBody MdmPriceConditionGroupRelFieldReqVo mdmPriceConditionGroupRelFieldReqVo);

    /**
     * 启用
     */
    @PostMapping("/mdmpriceconditiongrouprelfield/enable")
    Result enable(@RequestBody MdmPriceConditionGroupRelFieldReqVo mdmPriceConditionGroupRelFieldReqVo);

    /**
     * 禁用
     */
    @PostMapping("/mdmpriceconditiongrouprelfield/disable")
    Result disable(@RequestBody MdmPriceConditionGroupRelFieldReqVo mdmPriceConditionGroupRelFieldReqVo);
}
