package com.biz.crm.mdm.pricesetting.impl;

import com.biz.crm.mdm.pricesetting.MdmPriceSettingFeign;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceSearchReqVo;
import java.util.Map;

import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceResp;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceSettingRespVo;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceSettingReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;
import feign.hystrix.FallbackFactory;
import java.util.ArrayList;

/**
 * 价格维护主表 feign接口熔断类
 *
 * @author huanglong
 * @date 2020-10-20 13:49:03
 */
@Slf4j
@Component
public class MdmPriceSettingFeignImpl extends BaseAbstract implements FallbackFactory<MdmPriceSettingFeign> {

    @Override
    public MdmPriceSettingFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new MdmPriceSettingFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<MdmPriceSettingRespVo>> list(MdmPriceSettingReqVo mdmPriceSettingReqVo) {
                doBack();
                PageResult<MdmPriceSettingRespVo> build = PageResult.<MdmPriceSettingRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<MdmPriceSettingRespVo> query(MdmPriceSettingReqVo mdmPriceSettingReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(MdmPriceSettingReqVo mdmPriceSettingReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(MdmPriceSettingReqVo mdmPriceSettingReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(MdmPriceSettingReqVo mdmPriceSettingReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(MdmPriceSettingReqVo mdmPriceSettingReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(MdmPriceSettingReqVo mdmPriceSettingReqVo) {
                return doBack();
            }

            /**
             * 价格查询
             */
            @Override
            public Result<Map<String, Map<String, MdmPriceResp>>> search(MdmPriceSearchReqVo mdmPriceSearchReqVo) {
                return doBack();
            }

            /**
             * 询价
             */
            @Override
            public Result<Map<String, Map<String, MdmPriceResp>>> inquiry(MdmPriceSearchReqVo mdmPriceSearchReqVo) {
                return doBack();
            }
        };
    }
}
