package com.biz.crm.mdm.role;

import com.biz.crm.mdm.role.impl.MdmRoleFeignImpl;
import com.biz.crm.nebular.mdm.role.req.MdmUserRoleReqVo;
import com.biz.crm.nebular.mdm.role.resp.MdmRoleRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author liaohua
 * @Description: 角色管理Feign
 * @date 2020/10/23 2:20 下午
 */
@FeignClient(url = "${feign.urlip:}", qualifier = "MdmRoleFeign", name = "crm-mdm", path = "mdm", fallbackFactory = MdmRoleFeignImpl.class)
public interface MdmRoleFeign {
//    /**
//     * 列表
//     *
//     * @param mdmRoleReqVo
//     * @param pageable
//     * @return
//     */
//    @PostMapping("/mdmrole/list")
//    Result<PageResult<MdmRoleRespVo>> list(@RequestBody MdmRoleReqVo mdmRoleReqVo);
//
//    /**
//     * 权限角色列表条件查询
//     *
//     * @param mdmRoleSearchReqVo
//     * @return
//     */
//    @PostMapping("/mdmrole/list_condition")
//    Result<List<MdmRoleRespVo>> listCondition(@RequestBody MdmRoleSearchReqVo mdmRoleSearchReqVo);
//
//    /**
//     * 查询
//     *
//     * @param mdmRoleReqVo
//     * @return Result
//     */
//    @PostMapping("/mdmrole/query")
//    Result query(@RequestBody MdmRoleReqVo mdmRoleReqVo);
//
//    /**
//     * 新增
//     *
//     * @param mdmRoleReqVo
//     * @return Result
//     */
//    @PostMapping("/mdmrole/save")
//    Result save(@RequestBody MdmRoleReqVo mdmRoleReqVo);
//
//    /**
//     * 更新
//     *
//     * @param mdmRoleReqVo
//     * @return Result
//     */
//    @PostMapping("/mdmrole/update")
//    Result update(@RequestBody MdmRoleReqVo mdmRoleReqVo);
//
//    /**
//     * 删除
//     *
//     * @param mdmRoleReqVo
//     * @return
//     */
//    @PostMapping("/mdmrole/delete")
//    Result delete(@RequestBody MdmRoleReqVo mdmRoleReqVo);
//
//    /**
//     * 启用
//     *
//     * @param mdmRoleReqVo
//     * @return Result
//     */
//    @PostMapping("/mdmrole/enable")
//    Result enable(@RequestBody MdmRoleReqVo mdmRoleReqVo);
//
//    /**
//     * 禁用
//     *
//     * @param mdmRoleReqVo
//     * @return Result
//     */
    @PostMapping("/mdmRoleController/getRoleByPositionCode")
    Result<List<String>> getRoleByPositionCode(@RequestParam(value = "positionCode", required = true) String positionCode);

    @PostMapping("/mdmRoleController/getRoleByUserName")
    Result<List<String>> getRoleByUserName(@RequestParam(value = "userName", required = true) String userName);

    @ApiOperation("根据用户获取角色列表")
    @PostMapping("/mdmRoleController/obtainUserRoleList")
    Result<List<MdmRoleRespVo>> obtainUserRoleList(@RequestBody MdmUserRoleReqVo mdmUserRoleReqVo);

}
