package com.biz.crm.mdm.tableconfig.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.mdm.tableconfig.MdmColumnConfigPersonalFeign;
import com.biz.crm.nebular.mdm.tableconfig.MdmColumnConfigPersonalRedisVo;
import com.biz.crm.nebular.mdm.tableconfig.MdmColumnConfigPersonalRespVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 字段配置个性设置feign接口熔断类
 *
 * @author Tao.Chen
 * @date 2021-02-20 15:30:42
 */
@Slf4j
@Component
public class MdmColumnConfigPersonalFeignImpl extends BaseAbstract implements FallbackFactory<MdmColumnConfigPersonalFeign> {

    @Override
    public MdmColumnConfigPersonalFeign create(Throwable throwable) {
        log.error("进入熔断", throwable);
        return new MdmColumnConfigPersonalFeign() {

            @Override
            public Result<List<MdmColumnConfigPersonalRedisVo>> findColumnConfigPersonalRedisList(String parentCode, String functionCode,String positionCode) {
                return doBack();
            }
        };
    }
}
