package com.biz.crm.sfa.activity;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.activity.req.SfaActivityProductReqVo;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityProductRespVo;
import com.biz.crm.sfa.activity.impl.SfaActivityProductFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 活动产品;feign接口
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaActivityProductFeign",name="crm-sfa",path = "tpm",fallbackFactory = SfaActivityProductFeignImpl.class)
public interface SfaActivityProductFeign {

    /**
     * 列表
     */
    @PostMapping("/sfaActivityProductController/list")
    Result<PageResult<SfaActivityProductRespVo>> list(@RequestBody SfaActivityProductReqVo sfaActivityProductReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfaActivityProductController/query")
    Result<SfaActivityProductRespVo> query(@RequestBody SfaActivityProductReqVo sfaActivityProductReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfaActivityProductController/save")
    Result save(@RequestBody SfaActivityProductReqVo sfaActivityProductReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfaActivityProductController/update")
    Result update(@RequestBody SfaActivityProductReqVo sfaActivityProductReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfaActivityProductController/delete")
    Result delete(@RequestBody SfaActivityProductReqVo sfaActivityProductReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfaActivityProductController/enable")
    Result enable(@RequestBody SfaActivityProductReqVo sfaActivityProductReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfaActivityProductController/disable")
    Result disable(@RequestBody  SfaActivityProductReqVo sfaActivityProductReqVo);
}
