package com.biz.crm.sfa.actscheme;

import com.biz.crm.activiti.common.CallbackFeign;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.sfa.actscheme.impl.SfaActSchemePosApplyCallbackFeignImpl;
import com.biz.crm.sfa.worksign.impl.SfaWorkSignTravelEndFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @Description 方案活动申请审批流程回调
 * @Author Gavin
 * @Date Created in 2021/3/12 下午2:06
 */
@FeignClient(url ="${feign.urlip:}",qualifier = "SfaActSchemePosApplyCallbackFeign"
        ,name="crm-sfa",path = "sfa",fallbackFactory = SfaActSchemePosApplyCallbackFeignImpl.class)
public interface SfaActSchemePosApplyCallbackFeign extends CallbackFeign {

    /**
     * 流程审批监听回调
     * @param activitiCallBackVo
     * @return
     */
    @PostMapping("/sfaActSchemePosApplyController/callback")
    Result callback(@RequestBody ActivitiCallBackVo activitiCallBackVo);
}