package com.biz.crm.sfa.assistant;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkTaskReleaseReqVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkTaskReleaseRespVo;
import com.biz.crm.sfa.assistant.impl.SfaWorkTaskReleaseFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 工作任务(发布) feign接口
 *
 * @author liuhongming
 * @date 2020-10-14 19:54:03
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaWorkTaskReleaseFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaWorkTaskReleaseFeignImpl.class)
public interface SfaWorkTaskReleaseFeign {

    /**
     * 列表
     */
    @PostMapping("/sfaworktaskrelease/list")
    Result<PageResult<SfaWorkTaskReleaseRespVo>> list(@RequestBody SfaWorkTaskReleaseReqVo sfaWorkTaskReleaseReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfaworktaskrelease/query")
    Result<SfaWorkTaskReleaseRespVo> query(@RequestBody SfaWorkTaskReleaseReqVo sfaWorkTaskReleaseReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfaworktaskrelease/save")
    Result save(@RequestBody SfaWorkTaskReleaseReqVo sfaWorkTaskReleaseReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfaworktaskrelease/update")
    Result update(@RequestBody SfaWorkTaskReleaseReqVo sfaWorkTaskReleaseReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfaworktaskrelease/delete")
    Result delete(@RequestBody SfaWorkTaskReleaseReqVo sfaWorkTaskReleaseReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfaworktaskrelease/enable")
    Result enable(@RequestBody SfaWorkTaskReleaseReqVo sfaWorkTaskReleaseReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfaworktaskrelease/disable")
    Result disable(@RequestBody SfaWorkTaskReleaseReqVo sfaWorkTaskReleaseReqVo);
}
