package com.biz.crm.sfa.assistant.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkTaskReceveReqVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkTaskReceveRespVo;
import com.biz.crm.sfa.assistant.SfaWorkTaskReceveFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 工作任务(接收) feign接口熔断类
 *
 * @author liuhongming
 * @date 2020-10-14 19:54:03
 */
@Slf4j
@Component
public class SfaWorkTaskReceveFeignImpl extends BaseAbstract implements FallbackFactory<SfaWorkTaskReceveFeign> {

    @Override
    public SfaWorkTaskReceveFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaWorkTaskReceveFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaWorkTaskReceveRespVo>> list(SfaWorkTaskReceveReqVo sfaWorkTaskReceveReqVo) {
                doBack();
                PageResult<SfaWorkTaskReceveRespVo> build = PageResult.<SfaWorkTaskReceveRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaWorkTaskReceveRespVo> query(SfaWorkTaskReceveReqVo sfaWorkTaskReceveReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaWorkTaskReceveReqVo sfaWorkTaskReceveReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaWorkTaskReceveReqVo sfaWorkTaskReceveReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaWorkTaskReceveReqVo sfaWorkTaskReceveReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaWorkTaskReceveReqVo sfaWorkTaskReceveReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaWorkTaskReceveReqVo sfaWorkTaskReceveReqVo) {
                return doBack();
            }
        };
    }
}
