package com.biz.crm.sfa.collection;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.collection.req.SfaInputConfigReqVo;
import com.biz.crm.nebular.sfa.collection.resp.SfaInputConfigRespVo;
import com.biz.crm.sfa.collection.impl.SfaInputConfigFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 拜访控件 feign接口
 *
 * @author liuhongming
 * @date 2020-09-18 10:33:32
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaInputConfigFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaInputConfigFeignImpl.class)
public interface SfaInputConfigFeign {

    /**
     * 列表
     */
    @PostMapping("/sfainputconfig/list")
    Result<PageResult<SfaInputConfigRespVo>> list(@RequestBody SfaInputConfigReqVo sfaInputConfigReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfainputconfig/query")
    Result<SfaInputConfigRespVo> query(@RequestBody SfaInputConfigReqVo sfaInputConfigReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfainputconfig/save")
    Result save(@RequestBody SfaInputConfigReqVo sfaInputConfigReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfainputconfig/update")
    Result update(@RequestBody SfaInputConfigReqVo sfaInputConfigReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfainputconfig/delete")
    Result delete(@RequestBody SfaInputConfigReqVo sfaInputConfigReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfainputconfig/enable")
    Result enable(@RequestBody SfaInputConfigReqVo sfaInputConfigReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfainputconfig/disable")
    Result disable(@RequestBody SfaInputConfigReqVo sfaInputConfigReqVo);
}
