package com.biz.crm.sfa.collection.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.collection.req.SfaInputConfigReqVo;
import com.biz.crm.nebular.sfa.collection.resp.SfaInputConfigRespVo;
import com.biz.crm.sfa.collection.SfaInputConfigFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 拜访控件 feign接口熔断类
 *
 * @author liuhongming
 * @date 2020-09-18 10:33:32
 */
@Slf4j
@Component
public class SfaInputConfigFeignImpl extends BaseAbstract implements FallbackFactory<SfaInputConfigFeign> {

    @Override
    public SfaInputConfigFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaInputConfigFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaInputConfigRespVo>> list(SfaInputConfigReqVo sfaInputConfigReqVo) {
                doBack();
                PageResult<SfaInputConfigRespVo> build = PageResult.<SfaInputConfigRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaInputConfigRespVo> query(SfaInputConfigReqVo sfaInputConfigReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaInputConfigReqVo sfaInputConfigReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaInputConfigReqVo sfaInputConfigReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaInputConfigReqVo sfaInputConfigReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaInputConfigReqVo sfaInputConfigReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaInputConfigReqVo sfaInputConfigReqVo) {
                return doBack();
            }
        };
    }
}
