package com.biz.crm.sfa.collection.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.collection.req.SfaVisitRoleDirectoryReqVo;
import com.biz.crm.nebular.sfa.collection.resp.SfaVisitRoleDirectoryRespVo;
import com.biz.crm.sfa.collection.SfaVisitRoleDirectoryFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 拜访步骤配置(角色)--拜访步骤表单配置 feign接口熔断类
 *
 * @author liuhongming
 * @date 2020-09-18 14:49:32
 */
@Slf4j
@Component
public class SfaVisitRoleDirectoryFeignImpl extends BaseAbstract implements FallbackFactory<SfaVisitRoleDirectoryFeign> {

    @Override
    public SfaVisitRoleDirectoryFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaVisitRoleDirectoryFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaVisitRoleDirectoryRespVo>> list(SfaVisitRoleDirectoryReqVo sfaVisitRoleDirectoryReqVo) {
                doBack();
                PageResult<SfaVisitRoleDirectoryRespVo> build = PageResult.<SfaVisitRoleDirectoryRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaVisitRoleDirectoryRespVo> query(SfaVisitRoleDirectoryReqVo sfaVisitRoleDirectoryReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaVisitRoleDirectoryReqVo sfaVisitRoleDirectoryReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaVisitRoleDirectoryReqVo sfaVisitRoleDirectoryReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaVisitRoleDirectoryReqVo sfaVisitRoleDirectoryReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaVisitRoleDirectoryReqVo sfaVisitRoleDirectoryReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaVisitRoleDirectoryReqVo sfaVisitRoleDirectoryReqVo) {
                return doBack();
            }
        };
    }
}
