package com.biz.crm.sfa.map;

import com.biz.crm.common.PageResult;
import com.biz.crm.gaode.vo.AmapPoiQueryReqVo;
import com.biz.crm.gaode.vo.AmapPoiResultVo;
import com.biz.crm.gaode.vo.GaodeNearbyVo;
import com.biz.crm.gaode.vo.QueryAroundVo;
import com.biz.crm.sfa.map.impl.GaoDeFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 高德地图Api feign接口
 *
 * @author yangshan
 * @date 2021-3-9 15:28:27
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "GaoDeFeign",name="crm-webservice",path = "service",fallbackFactory = GaoDeFeignImpl.class)
public interface GaoDeFeign {

    /**
     * 列表
     * @param queryAroundVo
     * @return
     */
    @PostMapping("/gaode/gaodeAroundController/list")
    Result<PageResult<GaodeNearbyVo>> queryAround(@RequestBody QueryAroundVo queryAroundVo);

    @PostMapping("/gaode/gaodeAroundController/queryKeywords")
    Result<AmapPoiResultVo> queryKeywords(@RequestBody AmapPoiQueryReqVo reqVo);
}
