package com.biz.crm.sfa.moblie;

import com.biz.crm.activiti.common.CallbackFeign;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.sfa.moblie.impl.SfaCustomerFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * 订单审批流程回调
 * @author shuijie
 * @date 2021/3/2
 * @version: V1.0
 */

@FeignClient(url ="${feign.urlip:}",qualifier = "SfaOrderFeign"
        ,name="crm-sfa",path = "sfa",fallbackFactory = SfaCustomerFeignImpl.class)
public interface SfaOrderFeign extends CallbackFeign {

    /**
     * 订单审批流回调
     * @param activitiCallBackVo
     * @return
     */
    @PostMapping("sfaWorkDailyController/updateOrderApprovalStatus")
    Result callback(ActivitiCallBackVo activitiCallBackVo);
}
