package com.biz.crm.sfa.picture.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.picture.req.SfaVisitPictureReqVo;
import com.biz.crm.nebular.sfa.picture.resp.SfaVisitPictureRespVo;
import com.biz.crm.sfa.picture.SfaVisitPictureFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 拜访相关照片信息 feign接口熔断类
 *
 * @author liuhongming
 * @date 2020-10-15 15:32:29
 */
@Slf4j
@Component
public class SfaVisitPictureFeignImpl extends BaseAbstract implements FallbackFactory<SfaVisitPictureFeign> {

    @Override
    public SfaVisitPictureFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaVisitPictureFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaVisitPictureRespVo>> list(SfaVisitPictureReqVo sfaVisitPictureReqVo) {
                doBack();
                PageResult<SfaVisitPictureRespVo> build = PageResult.<SfaVisitPictureRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaVisitPictureRespVo> query(SfaVisitPictureReqVo sfaVisitPictureReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaVisitPictureReqVo sfaVisitPictureReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaVisitPictureReqVo sfaVisitPictureReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaVisitPictureReqVo sfaVisitPictureReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaVisitPictureReqVo sfaVisitPictureReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaVisitPictureReqVo sfaVisitPictureReqVo) {
                return doBack();
            }
        };
    }
}
