package com.biz.crm.sfa.visitdealer;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitdealer.req.SfaVisitDealerMonthlyReportReqVo;
import com.biz.crm.nebular.sfa.visitdealer.resp.SfaVisitDealerMonthlyReportRespVo;
import com.biz.crm.sfa.visitdealer.impl.SfaVisitDealerMonthlyReportFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 经销商拜访月度报表;feign接口
 *
 * @author lf
 * @date 2020-11-20 11:21:59
 */


@FeignClient(url = "${feign.urlip:}", qualifier = "SfaVisitDealerMonthlyReportFeign", name = "crm-sfa", path = "sfa", fallbackFactory = SfaVisitDealerMonthlyReportFeignImpl.class)
public interface SfaVisitDealerMonthlyReportFeign {

    /**
     * 列表
     */
    @PostMapping("/sfaVisitDealerMonthlyReportController/list")
    Result<PageResult<SfaVisitDealerMonthlyReportRespVo>> list(@RequestBody SfaVisitDealerMonthlyReportReqVo sfaVisitDealerMonthlyReportReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfaVisitDealerMonthlyReportController/query")
    Result<SfaVisitDealerMonthlyReportRespVo> query(@RequestBody SfaVisitDealerMonthlyReportReqVo sfaVisitDealerMonthlyReportReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfaVisitDealerMonthlyReportController/save")
    Result save(@RequestBody SfaVisitDealerMonthlyReportReqVo sfaVisitDealerMonthlyReportReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfaVisitDealerMonthlyReportController/update")
    Result update(@RequestBody SfaVisitDealerMonthlyReportReqVo sfaVisitDealerMonthlyReportReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfaVisitDealerMonthlyReportController/delete")
    Result delete(@RequestBody SfaVisitDealerMonthlyReportReqVo sfaVisitDealerMonthlyReportReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfaVisitDealerMonthlyReportController/enable")
    Result enable(@RequestBody SfaVisitDealerMonthlyReportReqVo sfaVisitDealerMonthlyReportReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfaVisitDealerMonthlyReportController/disable")
    Result disable(@RequestBody SfaVisitDealerMonthlyReportReqVo sfaVisitDealerMonthlyReportReqVo);

    @PostMapping("/sfaVisitDealerMonthlyReportController/produceVisitDetailReport")
    Result produceVisitDetailReport(@RequestBody SfaVisitDealerMonthlyReportReqVo sfaVisitDealerMonthlyReportReqVo);
}
