package com.biz.crm.sfa.visitnote.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitinfo.req.SfaVisitPlanInfoReqVo;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitPlanReqVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitPlanRespVo;
import com.biz.crm.sfa.visitnote.SfaVisitPlanFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;

import java.util.ArrayList;

/**
 * 拜访计划制定 feign接口熔断类
 *
 * @author liuhongming
 * @date 2020-09-21 14:35:05
 */
@Slf4j
@Component
public class SfaVisitPlanFeignImpl extends BaseAbstract implements FallbackFactory<SfaVisitPlanFeign> {

    @Override
    public SfaVisitPlanFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaVisitPlanFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaVisitPlanRespVo>> list(SfaVisitPlanReqVo sfaVisitPlanReqVo) {
                doBack();
                PageResult<SfaVisitPlanRespVo> build = PageResult.<SfaVisitPlanRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaVisitPlanRespVo> query(SfaVisitPlanReqVo sfaVisitPlanReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaVisitPlanReqVo sfaVisitPlanReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaVisitPlanReqVo sfaVisitPlanReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaVisitPlanReqVo sfaVisitPlanReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaVisitPlanReqVo sfaVisitPlanReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaVisitPlanReqVo sfaVisitPlanReqVo) {
                return doBack();
            }

            /**
             * 手动跑拜访计划规则
             * @param sfaVisitPlanInfoReqVo
             * @return
             */
            @PostMapping("/sfaVisitPlanController/produceSfaVisitRule")
            @Override
            public Result produceSfaVisitRule(SfaVisitPlanInfoReqVo sfaVisitPlanInfoReqVo) {
                return doBack();
            }


            /**
             * 定时任务——触发解析拜访计划
             * @return
             */
            @PostMapping("/sfaVisitPlanController/resolveVisitPlanForJob")
            @Override
            public Result resolveVisitPlanForJob(){ return doBack();}
        };
    }
}
