package com.biz.crm.sfa.visitnote.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitPlanRangeReqVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitPlanRangeRespVo;
import com.biz.crm.sfa.visitnote.SfaVisitPlanRangeFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 拜访计划制定范围表 feign接口熔断类
 *
 * @author liuhongming
 * @date 2020-09-21 14:35:05
 */
@Slf4j
@Component
public class SfaVisitPlanRangeFeignImpl extends BaseAbstract implements FallbackFactory<SfaVisitPlanRangeFeign> {

    @Override
    public SfaVisitPlanRangeFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaVisitPlanRangeFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaVisitPlanRangeRespVo>> list(SfaVisitPlanRangeReqVo sfaVisitPlanRangeReqVo) {
                doBack();
                PageResult<SfaVisitPlanRangeRespVo> build = PageResult.<SfaVisitPlanRangeRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaVisitPlanRangeRespVo> query(SfaVisitPlanRangeReqVo sfaVisitPlanRangeReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaVisitPlanRangeReqVo sfaVisitPlanRangeReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaVisitPlanRangeReqVo sfaVisitPlanRangeReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaVisitPlanRangeReqVo sfaVisitPlanRangeReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaVisitPlanRangeReqVo sfaVisitPlanRangeReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaVisitPlanRangeReqVo sfaVisitPlanRangeReqVo) {
                return doBack();
            }
        };
    }
}
