package com.biz.crm.sfa.visitstep;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitDisplayConfigReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitDisplayConfigRespVo;
import com.biz.crm.sfa.visitstep.impl.SfaVisitDisplayConfigFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 拜访(陈列执行配置) feign接口
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaVisitDisplayConfigFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaVisitDisplayConfigFeignImpl.class)
public interface SfaVisitDisplayConfigFeign {

    /**
     * 列表
     */
    @PostMapping("/sfavisitdisplayconfig/list")
    Result<PageResult<SfaVisitDisplayConfigRespVo>> list(@RequestBody SfaVisitDisplayConfigReqVo sfaVisitDisplayConfigReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfavisitdisplayconfig/query")
    Result<SfaVisitDisplayConfigRespVo> query(@RequestBody SfaVisitDisplayConfigReqVo sfaVisitDisplayConfigReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfavisitdisplayconfig/save")
    Result save(@RequestBody SfaVisitDisplayConfigReqVo sfaVisitDisplayConfigReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfavisitdisplayconfig/update")
    Result update(@RequestBody SfaVisitDisplayConfigReqVo sfaVisitDisplayConfigReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfavisitdisplayconfig/delete")
    Result delete(@RequestBody SfaVisitDisplayConfigReqVo sfaVisitDisplayConfigReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfavisitdisplayconfig/enable")
    Result enable(@RequestBody SfaVisitDisplayConfigReqVo sfaVisitDisplayConfigReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfavisitdisplayconfig/disable")
    Result disable(@RequestBody SfaVisitDisplayConfigReqVo sfaVisitDisplayConfigReqVo);
}
