package com.biz.crm.sfa.visitstep;

import com.biz.crm.nebular.sfa.tpmact.actcollect.SfaTpmActCollectVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActTableRespVo;
import com.biz.crm.sfa.visitstep.impl.SfaVisitStepTpmActivityFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author yangshan
 * @date 2021/6/17 14:51
 */
@FeignClient(url ="${feign.urlip:}",qualifier = "SfaVisitStepTpmActivityFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaVisitStepTpmActivityFeignImpl.class)
public interface SfaVisitStepTpmActivityFeign {

    /**
     * tpm活动-根据活动明细编码查询活动执行数据
     * @param actDetailCode
     * @return
     */
    @GetMapping("/sfaWorkDailyController/getTpmActExecuteDataByActDetailCode")
    Result<List<SfaTpmActCollectVo>> getTpmActExecuteDataByActDetailCode(@RequestParam("actDetailCode") String actDetailCode);

    /**
     * tpm活动-执行数据明细报表详情
     * @param id
     * @return
     */
    @GetMapping("/sfaTpmActController/loadTpmActCollectDetailTableById")
    Result<SfaTpmActTableRespVo> loadTpmActCollectDetailTableById(@RequestParam("id") String id);
}
