package com.biz.crm.sfa.visitstep.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepColletItemReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepColletItemRespVo;
import com.biz.crm.sfa.visitstep.SfaVisitStepColletItemFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 拜访步骤(竞品采集明细) feign接口熔断类
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
@Slf4j
@Component
public class SfaVisitStepColletItemFeignImpl extends BaseAbstract implements FallbackFactory<SfaVisitStepColletItemFeign> {

    @Override
    public SfaVisitStepColletItemFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaVisitStepColletItemFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaVisitStepColletItemRespVo>> list(SfaVisitStepColletItemReqVo sfaVisitStepColletItemReqVo) {
                doBack();
                PageResult<SfaVisitStepColletItemRespVo> build = PageResult.<SfaVisitStepColletItemRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaVisitStepColletItemRespVo> query(SfaVisitStepColletItemReqVo sfaVisitStepColletItemReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaVisitStepColletItemReqVo sfaVisitStepColletItemReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaVisitStepColletItemReqVo sfaVisitStepColletItemReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaVisitStepColletItemReqVo sfaVisitStepColletItemReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaVisitStepColletItemReqVo sfaVisitStepColletItemReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaVisitStepColletItemReqVo sfaVisitStepColletItemReqVo) {
                return doBack();
            }
        };
    }
}
