package com.biz.crm.sfa.worksignrule;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignExecuteReqVo;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignRuleReqVo;
import com.biz.crm.nebular.sfa.worksignrule.SfaWorkSignRuleVo;
import com.biz.crm.nebular.sfa.worksignrule.resp.SfaWorkSignRuleRespVo;
import com.biz.crm.sfa.worksignrule.impl.SfaWorkSignRuleFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
/**
 * 考勤规则;考勤规则feign接口
 *
 * @author liuhongming
 * @date 2020-09-16 14:50:03
 */


@FeignClient(
        url ="${feign.urlip:}",
        qualifier = "SfaWorkSignRuleFeign",
        name="crm-sfa",
        path = "sfa",
        fallbackFactory = SfaWorkSignRuleFeignImpl.class
)
public interface SfaWorkSignRuleFeign {

    /**
     * 列表
     */
    @PostMapping("/sfaworksignrule/list")
    Result<PageResult<SfaWorkSignRuleRespVo>> list(@RequestBody SfaWorkSignRuleVo sfaWorkSignRuleVo);

    /**
     * 查询
     */
    @PostMapping("/sfaworksignrule/query")
    Result<SfaWorkSignRuleRespVo> query(@RequestBody SfaWorkSignRuleReqVo sfaWorkSignRuleReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfaworksignrule/save")
    Result save(@RequestBody SfaWorkSignRuleReqVo sfaWorkSignRuleReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfaworksignrule/update")
    Result update(@RequestBody SfaWorkSignRuleReqVo sfaWorkSignRuleReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfaworksignrule/delete")
    Result delete(@RequestBody SfaWorkSignRuleReqVo sfaWorkSignRuleReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfaworksignrule/enable")
    Result enable(@RequestBody SfaWorkSignRuleReqVo sfaWorkSignRuleReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfaworksignrule/disable")
    Result disable(@RequestBody SfaWorkSignRuleReqVo sfaWorkSignRuleReqVo);

}
