package com.biz.crm.sfa.worksignrule.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignPlaceReqVo;
import com.biz.crm.nebular.sfa.worksignrule.resp.SfaWorkSignPlaceRespVo;
import com.biz.crm.sfa.worksignrule.SfaWorkSignPlaceFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 考勤规则-打卡地点 feign接口熔断类
 *
 * @author liuhongming
 * @date 2020-09-16 15:06:20
 */
@Slf4j
@Component
public class SfaWorkSignPlaceFeignImpl extends BaseAbstract implements FallbackFactory<SfaWorkSignPlaceFeign> {

    @Override
    public SfaWorkSignPlaceFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaWorkSignPlaceFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaWorkSignPlaceRespVo>> list(SfaWorkSignPlaceReqVo sfaWorkSignPlaceReqVo) {
                doBack();
                PageResult<SfaWorkSignPlaceRespVo> build = PageResult.<SfaWorkSignPlaceRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaWorkSignPlaceRespVo> query(SfaWorkSignPlaceReqVo sfaWorkSignPlaceReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaWorkSignPlaceReqVo sfaWorkSignPlaceReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaWorkSignPlaceReqVo sfaWorkSignPlaceReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaWorkSignPlaceReqVo sfaWorkSignPlaceReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaWorkSignPlaceReqVo sfaWorkSignPlaceReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaWorkSignPlaceReqVo sfaWorkSignPlaceReqVo) {
                return doBack();
            }
        };
    }
}
