package com.biz.crm.sfa.worksignrule.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignSpecialReqVo;
import com.biz.crm.nebular.sfa.worksignrule.resp.SfaWorkSignSpecialRespVo;
import com.biz.crm.sfa.worksignrule.SfaWorkSignSpecialFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 特殊日期 feign接口熔断类
 *
 * @author liuhongming
 * @date 2020-09-16 15:06:20
 */
@Slf4j
@Component
public class SfaWorkSignSpecialFeignImpl extends BaseAbstract implements FallbackFactory<SfaWorkSignSpecialFeign> {

    @Override
    public SfaWorkSignSpecialFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaWorkSignSpecialFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaWorkSignSpecialRespVo>> list(SfaWorkSignSpecialReqVo sfaWorkSignSpecialReqVo) {
                doBack();
                PageResult<SfaWorkSignSpecialRespVo> build = PageResult.<SfaWorkSignSpecialRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaWorkSignSpecialRespVo> query(SfaWorkSignSpecialReqVo sfaWorkSignSpecialReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaWorkSignSpecialReqVo sfaWorkSignSpecialReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaWorkSignSpecialReqVo sfaWorkSignSpecialReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaWorkSignSpecialReqVo sfaWorkSignSpecialReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaWorkSignSpecialReqVo sfaWorkSignSpecialReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaWorkSignSpecialReqVo sfaWorkSignSpecialReqVo) {
                return doBack();
            }
        };
    }
}
