package com.biz.crm.tpm.account.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.tpm.account.req.TpmAccountProductReqVo;
import com.biz.crm.nebular.tpm.account.resp.TpmAccountProductRespVo;
import com.biz.crm.tpm.account.TpmAccountProductFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 费用上账货补产品表 feign接口熔断类
 *
 * @author zeyi
 * @date 2020-10-12 17:26:54
 */
@Slf4j
@Component
public class TpmAccountProductFeignImpl extends BaseAbstract implements FallbackFactory<TpmAccountProductFeign> {

    @Override
    public TpmAccountProductFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new TpmAccountProductFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<TpmAccountProductRespVo>> list(TpmAccountProductReqVo tpmAccountProductReqVo) {
                doBack();
                PageResult<TpmAccountProductRespVo> build = PageResult.<TpmAccountProductRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<TpmAccountProductRespVo> query(TpmAccountProductReqVo tpmAccountProductReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(TpmAccountProductReqVo tpmAccountProductReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(TpmAccountProductReqVo tpmAccountProductReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(TpmAccountProductReqVo tpmAccountProductReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(TpmAccountProductReqVo tpmAccountProductReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(TpmAccountProductReqVo tpmAccountProductReqVo) {
                return doBack();
            }
        };
    }
}
