package com.biz.crm.tpm.act;

import com.biz.crm.activiti.common.CallbackFeign;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.tpm.act.req.ActGetCategoriesByBudgetReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActDetailReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActReqVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActRespVo;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesRespVo;
import com.biz.crm.nebular.tpm.costtypefine.resp.TpmCostTypeFineRespVo;
import com.biz.crm.tpm.act.impl.TpmActCallBackFeignImpl;
import com.biz.crm.tpm.act.impl.TpmActFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 活动提交审批回调;feign接口
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "TpmActCallBackFeign",name="crm-tpm",path = "tpm",fallbackFactory = TpmActCallBackFeignImpl.class)
public interface TpmActCallBackFeign extends CallbackFeign {

    /**
     * 回调方法
     * @param activitiCallBackVo
     * @return
     */
    @Override
    @PostMapping("/tpmActController/activityCallBack")
    Result callback(@RequestBody ActivitiCallBackVo activitiCallBackVo);
}
