package com.biz.crm.tpm.audit;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditDetailRespVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditDetailReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import com.biz.crm.tpm.audit.impl.TpmAuditDetailFeignImpl;

/**
 * 核销申请明细表 feign接口
 *
 * @author huanglong
 * @date 2020-10-09 14:05:45
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "TpmAuditDetailFeign",name="crm-tpm",path = "tpm",fallbackFactory = TpmAuditDetailFeignImpl.class)
public interface TpmAuditDetailFeign {

    /**
     * 列表
     */
    @PostMapping("/tpmauditdetail/list")
    Result<PageResult<TpmAuditDetailRespVo>> list(@RequestBody TpmAuditDetailReqVo tpmAuditDetailReqVo);

    /**
     * 上账核销明细查询
     */
    @PostMapping("/tpmauditdetail/findAccountAuditDetail")
    Result<PageResult<TpmAuditDetailRespVo>> findAccountAuditDetail(@RequestBody TpmAuditDetailReqVo tpmAuditDetailReqVo);

    /**
     * 生成上账总单号
     */
    @PostMapping("/tpmauditdetail/generateAccountCode")
    Result generateAccountCode(@RequestBody Integer num);

    /**
     * 新增
     */
    @PostMapping("/tpmauditdetail/save")
    Result save(@RequestBody TpmAuditDetailReqVo tpmAuditDetailReqVo);

    /**
     * 更新
     */
    @PostMapping("/tpmauditdetail/update")
    Result update(@RequestBody TpmAuditDetailReqVo tpmAuditDetailReqVo);

    /**
     * 删除
     */
    @PostMapping("/tpmauditdetail/delete")
    Result delete(@RequestBody TpmAuditDetailReqVo tpmAuditDetailReqVo);

    /**
     * 启用
     */
    @PostMapping("/tpmauditdetail/enable")
    Result enable(@RequestBody TpmAuditDetailReqVo tpmAuditDetailReqVo);

    /**
     * 禁用
     */
    @PostMapping("/tpmauditdetail/disable")
    Result disable(@RequestBody TpmAuditDetailReqVo tpmAuditDetailReqVo);
}
