package com.biz.crm.tpm.audit.impl;

import lombok.extern.slf4j.Slf4j;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditActRespVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditActReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;
import com.biz.crm.tpm.audit.TpmAuditActFeign;
import feign.hystrix.FallbackFactory;
import java.util.ArrayList;

/**
 * 核销申请活动表 feign接口熔断类
 *
 * @author huanglong
 * @date 2020-10-09 14:05:45
 */
@Slf4j
@Component
public class TpmAuditActFeignImpl extends BaseAbstract implements FallbackFactory<TpmAuditActFeign> {

    @Override
    public TpmAuditActFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new TpmAuditActFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<TpmAuditActRespVo>> list(TpmAuditActReqVo tpmAuditActReqVo) {
                doBack();
                PageResult<TpmAuditActRespVo> build = PageResult.<TpmAuditActRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<TpmAuditActRespVo> query(TpmAuditActReqVo tpmAuditActReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(TpmAuditActReqVo tpmAuditActReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(TpmAuditActReqVo tpmAuditActReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(TpmAuditActReqVo tpmAuditActReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(TpmAuditActReqVo tpmAuditActReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(TpmAuditActReqVo tpmAuditActReqVo) {
                return doBack();
            }
        };
    }
}
