package com.biz.crm.tpm.audit.impl;

import lombok.extern.slf4j.Slf4j;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditDetailRespVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditDetailReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;
import com.biz.crm.tpm.audit.TpmAuditDetailFeign;
import feign.hystrix.FallbackFactory;
import java.util.ArrayList;

/**
 * 核销申请明细表 feign接口熔断类
 *
 * @author huanglong
 * @date 2020-10-09 14:05:45
 */
@Slf4j
@Component
public class TpmAuditDetailFeignImpl extends BaseAbstract implements FallbackFactory<TpmAuditDetailFeign> {

    @Override
    public TpmAuditDetailFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new TpmAuditDetailFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<TpmAuditDetailRespVo>> list(TpmAuditDetailReqVo tpmAuditDetailReqVo) {
                doBack();
                PageResult<TpmAuditDetailRespVo> build = PageResult.<TpmAuditDetailRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 上账核销明细查询
             */
            @Override
            public Result<PageResult<TpmAuditDetailRespVo>> findAccountAuditDetail(TpmAuditDetailReqVo tpmAuditDetailReqVo) {
                doBack();
                PageResult<TpmAuditDetailRespVo> build = PageResult.<TpmAuditDetailRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 生成上账总单号
             */
            @Override
            public Result generateAccountCode(Integer num) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(TpmAuditDetailReqVo tpmAuditDetailReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(TpmAuditDetailReqVo tpmAuditDetailReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(TpmAuditDetailReqVo tpmAuditDetailReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(TpmAuditDetailReqVo tpmAuditDetailReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(TpmAuditDetailReqVo tpmAuditDetailReqVo) {
                return doBack();
            }
        };
    }
}
