package com.biz.crm.tpm.auditcollectexample;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.biz.crm.nebular.tpm.auditcollectexample.resp.TpmAuditCollectExamplePictureRespVo;
import com.biz.crm.nebular.tpm.auditcollectexample.req.TpmAuditCollectExamplePictureReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import com.biz.crm.tpm.auditcollectexample.impl.TpmAuditCollectExamplePictureFeignImpl;

/**
 * 核销采集示例图片表 feign接口
 *
 * @author huang.long
 * @date 2020-09-09 18:20:33
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "TpmAuditCollectExamplePictureFeign",name="crm-tpm",path = "tpm",fallbackFactory = TpmAuditCollectExamplePictureFeignImpl.class)
public interface TpmAuditCollectExamplePictureFeign {

    /**
     * 列表
     */
    @PostMapping("/tpmauditcollectexamplepicture/list")
    Result<PageResult<TpmAuditCollectExamplePictureRespVo>> list(@RequestBody TpmAuditCollectExamplePictureReqVo tpmAuditCollectExamplePictureReqVo);

    /**
     * 查询
     */
    @PostMapping("/tpmauditcollectexamplepicture/query")
    Result<TpmAuditCollectExamplePictureRespVo> query(@RequestBody TpmAuditCollectExamplePictureReqVo tpmAuditCollectExamplePictureReqVo);

    /**
     * 新增
     */
    @PostMapping("/tpmauditcollectexamplepicture/save")
    Result save(@RequestBody TpmAuditCollectExamplePictureReqVo tpmAuditCollectExamplePictureReqVo);

    /**
     * 更新
     */
    @PostMapping("/tpmauditcollectexamplepicture/update")
    Result update(@RequestBody TpmAuditCollectExamplePictureReqVo tpmAuditCollectExamplePictureReqVo);

    /**
     * 删除
     */
    @PostMapping("/tpmauditcollectexamplepicture/delete")
    Result delete(@RequestBody TpmAuditCollectExamplePictureReqVo tpmAuditCollectExamplePictureReqVo);

    /**
     * 启用
     */
    @PostMapping("/tpmauditcollectexamplepicture/enable")
    Result enable(@RequestBody TpmAuditCollectExamplePictureReqVo tpmAuditCollectExamplePictureReqVo);

    /**
     * 禁用
     */
    @PostMapping("/tpmauditcollectexamplepicture/disable")
    Result disable(@RequestBody TpmAuditCollectExamplePictureReqVo tpmAuditCollectExamplePictureReqVo);
}
