package com.biz.crm.tpm.auditcollectexample.impl;

import lombok.extern.slf4j.Slf4j;
import com.biz.crm.nebular.tpm.auditcollectexample.resp.TpmAuditCollectExampleRespVo;
import com.biz.crm.nebular.tpm.auditcollectexample.req.TpmAuditCollectExampleReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;
import com.biz.crm.tpm.auditcollectexample.TpmAuditCollectExampleFeign;
import feign.hystrix.FallbackFactory;

import java.util.ArrayList;

/**
 * 核销采集示例主表 feign接口熔断类
 *
 * @author huang.long
 * @date 2020-09-09 18:20:33
 */
@Slf4j
@Component
public class TpmAuditCollectExampleFeignImpl extends BaseAbstract implements FallbackFactory<TpmAuditCollectExampleFeign> {

    @Override
    public TpmAuditCollectExampleFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new TpmAuditCollectExampleFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<TpmAuditCollectExampleRespVo>> list(TpmAuditCollectExampleReqVo tpmAuditCollectExampleReqVo) {
                doBack();
                PageResult<TpmAuditCollectExampleRespVo> build = PageResult.<TpmAuditCollectExampleRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<TpmAuditCollectExampleRespVo> query(TpmAuditCollectExampleReqVo tpmAuditCollectExampleReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(TpmAuditCollectExampleReqVo tpmAuditCollectExampleReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(TpmAuditCollectExampleReqVo tpmAuditCollectExampleReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(TpmAuditCollectExampleReqVo tpmAuditCollectExampleReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(TpmAuditCollectExampleReqVo tpmAuditCollectExampleReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(TpmAuditCollectExampleReqVo tpmAuditCollectExampleReqVo) {
                return doBack();
            }
        };
    }
}
