package com.biz.crm.tpm.costtypecategories;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesFineRespVo;
import com.biz.crm.nebular.tpm.costtypecategories.req.TpmCostTypeCategoriesFineReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import com.biz.crm.tpm.costtypecategories.impl.TpmCostTypeCategoriesFineFeignImpl;

/**
 * 活动大类与活动细类的关联表 feign接口
 *
 * @author huanglong
 * @date 2020-09-10 17:04:14
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "TpmCostTypeCategoriesFineFeign",name="crm-tpm",path = "tpm",fallbackFactory = TpmCostTypeCategoriesFineFeignImpl.class)
public interface TpmCostTypeCategoriesFineFeign {

    /**
     * 列表
     */
    @PostMapping("/tpmcosttypecategoriesfine/list")
    Result<PageResult<TpmCostTypeCategoriesFineRespVo>> list(@RequestBody TpmCostTypeCategoriesFineReqVo tpmCostTypeCategoriesFineReqVo);

    /**
     * 查询
     */
    @PostMapping("/tpmcosttypecategoriesfine/query")
    Result<TpmCostTypeCategoriesFineRespVo> query(@RequestBody TpmCostTypeCategoriesFineReqVo tpmCostTypeCategoriesFineReqVo);

    /**
     * 新增
     */
    @PostMapping("/tpmcosttypecategoriesfine/save")
    Result save(@RequestBody TpmCostTypeCategoriesFineReqVo tpmCostTypeCategoriesFineReqVo);

    /**
     * 更新
     */
    @PostMapping("/tpmcosttypecategoriesfine/update")
    Result update(@RequestBody TpmCostTypeCategoriesFineReqVo tpmCostTypeCategoriesFineReqVo);

    /**
     * 删除
     */
    @PostMapping("/tpmcosttypecategoriesfine/delete")
    Result delete(@RequestBody TpmCostTypeCategoriesFineReqVo tpmCostTypeCategoriesFineReqVo);

    /**
     * 启用
     */
    @PostMapping("/tpmcosttypecategoriesfine/enable")
    Result enable(@RequestBody TpmCostTypeCategoriesFineReqVo tpmCostTypeCategoriesFineReqVo);

    /**
     * 禁用
     */
    @PostMapping("/tpmcosttypecategoriesfine/disable")
    Result disable(@RequestBody TpmCostTypeCategoriesFineReqVo tpmCostTypeCategoriesFineReqVo);
}
