package com.biz.crm.tpm.costtypecategories.impl;

import com.biz.crm.nebular.tpm.act.req.ActGetCategoriesByBudgetReqVo;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesRespVo;
import com.biz.crm.nebular.tpm.costtypecategories.req.TpmCostTypeCategoriesReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;
import com.biz.crm.tpm.costtypecategories.TpmCostTypeCategoriesFeign;
import feign.hystrix.FallbackFactory;

import java.util.ArrayList;
import java.util.List;

/**
 * 活动大类 feign接口熔断类
 *
 * @author huanglong
 * @date 2020-09-10 17:04:14
 */
@Slf4j
@Component
public class TpmCostTypeCategoriesFeignImpl extends BaseAbstract implements FallbackFactory<TpmCostTypeCategoriesFeign> {

    @Override
    public TpmCostTypeCategoriesFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new TpmCostTypeCategoriesFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<TpmCostTypeCategoriesRespVo>> list(TpmCostTypeCategoriesReqVo tpmCostTypeCategoriesReqVo) {
                doBack();
                PageResult<TpmCostTypeCategoriesRespVo> build = PageResult.<TpmCostTypeCategoriesRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<TpmCostTypeCategoriesRespVo> query(TpmCostTypeCategoriesReqVo tpmCostTypeCategoriesReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(TpmCostTypeCategoriesReqVo tpmCostTypeCategoriesReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(TpmCostTypeCategoriesReqVo tpmCostTypeCategoriesReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(TpmCostTypeCategoriesReqVo tpmCostTypeCategoriesReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(TpmCostTypeCategoriesReqVo tpmCostTypeCategoriesReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(TpmCostTypeCategoriesReqVo tpmCostTypeCategoriesReqVo) {
                return doBack();
            }

        };
    }
}
