package com.biz.crm.tpm.liqueuract;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.tpm.act.TpmActCallBackFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 活动提交审批回调;feign接口熔断类
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */
@Slf4j
@Component
public class TpmLiqueurActRegisterCallBackFeignImpl extends BaseAbstract implements FallbackFactory<TpmLiqueurActRegisterCallBackFeign> {

    @Override
    public TpmLiqueurActRegisterCallBackFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new TpmLiqueurActRegisterCallBackFeign() {
            @Override
            public Result callback(ActivitiCallBackVo activitiCallBackVo) {
                return doBack();
            }
        };
    }
}
