package com.biz.crm.upload.excel;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.upload.excel.req.ExcelExportReqVo;
import com.biz.crm.nebular.upload.excel.resp.ExcelExportRespVo;
import com.biz.crm.upload.excel.impl.ExcelExportFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 导出文件feign接口
 *
 * @author lf
 * @date 2020-12-06 17:11:15
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "ExcelExportFeign",name="crm-upload",path = "upload",fallbackFactory = ExcelExportFeignImpl.class)
public interface ExcelExportFeign {

    /**
     * 列表
     */
    @PostMapping("/excelExportController/list")
    Result<PageResult<ExcelExportRespVo>> list(@RequestBody ExcelExportReqVo excelExportReqVo);

    /**
     * 查询
     */
    @PostMapping("/excelExportController/query")
    Result<ExcelExportRespVo> query(@RequestBody ExcelExportReqVo excelExportReqVo);

    /**
     * 新增
     */
    @PostMapping("/excelExportController/save")
    Result save(@RequestBody ExcelExportReqVo excelExportReqVo);

    /**
     * 新增并返回id
     * @param excelExportReqVo
     * @return
     */
    @PostMapping("/excelExportController/saveExcelFileBackId")
    Result<ExcelExportReqVo> saveExcelFileBackId(@RequestBody ExcelExportReqVo excelExportReqVo);

    /**
     * 更新数据
     * @param excelExportReqVo
     * @return
     */
    @PostMapping("/excelExportController/updateExcelFileById")
    Result updateExcelFileById(@RequestBody ExcelExportReqVo excelExportReqVo);

    /**
     * 更新
     */
    @PostMapping("/excelExportController/update")
    Result update(@RequestBody ExcelExportReqVo excelExportReqVo);

    /**
     * 删除
     */
    @PostMapping("/excelExportController/delete")
    Result delete(@RequestBody ExcelExportReqVo excelExportReqVo);

    /**
     * 启用
     */
    @PostMapping("/excelExportController/enable")
    Result enable(@RequestBody ExcelExportReqVo excelExportReqVo);

    /**
     * 禁用
     */
    @PostMapping("/excelExportController/disable")
    Result disable(@RequestBody  ExcelExportReqVo excelExportReqVo);
}
