/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.config;

import com.alibaba.fastjson.JSON;
import com.biz.crm.config.SpringApplicationContext;
import com.biz.crm.external.YzjFeignClient;
import com.biz.crm.nebular.yzj.YzjCommonResVo;
import com.biz.crm.nebular.yzj.token.AccessTokenReqVo;
import com.biz.crm.nebular.yzj.token.AccessTokenResVo;
import com.biz.crm.nebular.yzj.user.QueryUserInfo;
import com.google.common.collect.Maps;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.core.RedisTemplate;

public class YzjFeignClientConfiguration
implements RequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(YzjFeignClientConfiguration.class);
    private static final String TOKENURL = "/gateway/oauth2/token/getAccessToken";
    private static final String GETPERSON = "/gateway/openimport/open/person/get";
    private static RedisTemplate redisTemplate;
    private RedissonClient redissonClient;
    private static YzjFeignClient yzjFeignClient;
    private static Environment env;
    public static final int YZJ_TOKEN_EXPIE_TIME = 6000;

    public void apply(RequestTemplate requestTemplate) {
        this.init();
        String path = requestTemplate.path();
        if (!StringUtils.equals((CharSequence)TOKENURL, (CharSequence)path)) {
            if (!StringUtils.equals((CharSequence)GETPERSON, (CharSequence)path)) {
                String accessToken = this.getAppAccessToken();
                requestTemplate.query("accessToken", new String[]{accessToken});
            } else {
                String accessToken = this.getGroupAccessToken();
                String s = requestTemplate.requestBody().asString();
                if (StringUtils.isNotEmpty((CharSequence)s)) {
                    QueryUserInfo queryUserInfo = (QueryUserInfo)JSON.parseObject((String)s, QueryUserInfo.class);
                    requestTemplate.query("eid", new String[]{queryUserInfo.getEid()});
                    requestTemplate.query("data", new String[]{queryUserInfo.getData()});
                }
                requestTemplate.query("accessToken", new String[]{accessToken});
            }
        }
    }

    public static void main(String[] args) {
        System.out.println(System.currentTimeMillis());
    }

    private void init() {
        if (redisTemplate == null) {
            redisTemplate = (RedisTemplate)SpringApplicationContext.getApplicationContext().getBean("redisTemplate");
        }
        if (yzjFeignClient == null) {
            yzjFeignClient = (YzjFeignClient)SpringApplicationContext.getApplicationContext().getBean(YzjFeignClient.class);
        }
        if (env == null) {
            env = (Environment)SpringApplicationContext.getApplicationContext().getBean(Environment.class);
        }
        if (this.redissonClient == null) {
            this.redissonClient = (RedissonClient)SpringApplicationContext.getApplicationContext().getBean(RedissonClient.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAppAccessToken() {
        String access = null;
        RLock rLock = this.redissonClient.getLock("yzj:access:token:lock:app");
        try {
            access = (String)redisTemplate.opsForHash().get((Object)"yzj:access:key:app", (Object)"token");
            if (StringUtils.isEmpty((CharSequence)access)) {
                rLock.lock();
                access = (String)redisTemplate.opsForHash().get((Object)"yzj:access:key:app", (Object)"token");
                if (StringUtils.isNotEmpty((CharSequence)access)) {
                    String string = access;
                    return string;
                }
                AccessTokenReqVo accessTokenResVo = new AccessTokenReqVo();
                accessTokenResVo.setAppId(env.getProperty("yzj.appid"));
                accessTokenResVo.setSecret(env.getProperty("yzj.secret"));
                accessTokenResVo.setTimestamp(System.currentTimeMillis());
                YzjCommonResVo<AccessTokenResVo> accessToken = yzjFeignClient.getAccessToken(accessTokenResVo);
                if (accessToken != null) {
                    AccessTokenResVo data = (AccessTokenResVo)accessToken.getData();
                    access = data.getAccessToken();
                    HashMap map = Maps.newHashMap();
                    map.put("token", access);
                    map.put("reftoken", data.getRefreshToken());
                    redisTemplate.opsForHash().putAll((Object)"yzj:access:key:app", (Map)map);
                    redisTemplate.expire((Object)"yzj:access:key:app", 6000L, TimeUnit.SECONDS);
                }
            }
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u4e91\u4e4b\u5bb6token\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (rLock.isLocked()) {
                rLock.unlock();
            }
        }
        return access;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGroupAccessToken() {
        String access = null;
        RLock rLock = this.redissonClient.getLock("yzj:access:token:lock:group");
        try {
            access = (String)redisTemplate.opsForHash().get((Object)"yzj:access:key:group", (Object)"token");
            if (StringUtils.isEmpty((CharSequence)access)) {
                rLock.lock();
                access = (String)redisTemplate.opsForHash().get((Object)"yzj:access:key:group", (Object)"token");
                if (StringUtils.isNotEmpty((CharSequence)access)) {
                    String string = access;
                    return string;
                }
                AccessTokenReqVo accessTokenResVo = new AccessTokenReqVo();
                accessTokenResVo.setEid(env.getProperty("yzj.eid"));
                accessTokenResVo.setSecret(env.getProperty("yzj.groupsecret"));
                accessTokenResVo.setTimestamp(System.currentTimeMillis());
                accessTokenResVo.setScope("resGroupSecret");
                YzjCommonResVo<AccessTokenResVo> accessToken = yzjFeignClient.getAccessToken(accessTokenResVo);
                if (accessToken != null) {
                    AccessTokenResVo data = (AccessTokenResVo)accessToken.getData();
                    access = data.getAccessToken();
                    HashMap map = Maps.newHashMap();
                    map.put("token", access);
                    map.put("reftoken", data.getRefreshToken());
                    redisTemplate.opsForHash().putAll((Object)"yzj:access:key:group", (Map)map);
                    redisTemplate.expire((Object)"yzj:access:key:group", 6000L, TimeUnit.SECONDS);
                }
            }
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u4e91\u4e4b\u5bb6token\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (rLock.isLocked()) {
                rLock.unlock();
            }
        }
        return access;
    }

    public static class RedisKey {
        public static final String YZJ_ACCESS_TOKEN_LOCK_APP = "yzj:access:token:lock:app";
        public static final String YZJ_ACCESS_TOKEN_LOCK_GROUP = "yzj:access:token:lock:group";
        public static final String YZJ_ACCESS_KEY_APP = "yzj:access:key:app";
        public static final String YZJ_ACCESS_KEY_GROUP = "yzj:access:key:group";
        public static final String YZJ_ACCESS_TOKEN = "token";
        public static final String YZJ_REF_ACCESS_TOKEN = "reftoken";
        public static final String WXH5_ACCESS_KEY = "yzj:access:key";
    }
}

