package com.biz.crm.activiti.act;

import com.biz.crm.activiti.act.impl.TaActBaseProcessFeignImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.activiti.act.req.TaActBaseProcessReqVo;
import com.biz.crm.nebular.activiti.act.resp.TaActBaseProcessRespVo;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * feign接口
 *
 * @author jerry7
 * @date 2020-12-05 15:36:45
 */


@FeignClient(url = "${feign.urlip:}", qualifier = "TaActBaseProcessFeign", name = "crm-activiti", path = "activiti", fallbackFactory = TaActBaseProcessFeignImpl.class)
public interface TaActBaseProcessFeign {

    /**
     * 列表
     */
    @PostMapping("/taactbaseprocess/list")
    Result<PageResult<TaActBaseProcessRespVo>> list(@RequestBody TaActBaseProcessReqVo taActBaseProcessReqVo);

    /**
     * 查询
     */
    @GetMapping("/taactbaseprocess/query")
    Result<TaActBaseProcessRespVo> query(@RequestParam("id") String id);

    /**
     * 新增
     */
    @PostMapping("/taactbaseprocess/save")
    Result save(@RequestBody TaActBaseProcessReqVo taActBaseProcessReqVo);

    /**
     * 更新
     */
    @PostMapping("/taactbaseprocess/update")
    Result update(@RequestBody TaActBaseProcessReqVo taActBaseProcessReqVo);

    /**
     * 删除
     */
    @PostMapping("/taactbaseprocess/delete")
    Result delete(@RequestBody List<String> ids);

    /**
     * 流程关闭
     *
     * @param vo
     * @return
     */
    @PostMapping("/taactbaseprocess/close")
    Result close(@RequestBody TaActBaseProcessReqVo vo);

    /**
     * 启用
     *
     * @param ids
     * @return
     */
    @PostMapping("/taactbaseprocess/enable")
    Result enable(@RequestBody List<String> ids);

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    @PostMapping("/taactbaseprocess/disable")
    Result disable(@RequestBody List<String> ids);

}
