package com.biz.crm.activiti.act;

import com.biz.crm.activiti.act.impl.TaActFileFeignImpl;
import com.biz.crm.nebular.activiti.act.req.TaActFileReqVo;
import com.biz.crm.nebular.activiti.act.resp.TaActFileRespVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;

/**
 * 工作流文件feign接口
 *
 * @author jerry7
 * @date 2021-01-14 18:17:13
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "TaActFileFeign",name="crm-activiti",path = "activiti",fallbackFactory = TaActFileFeignImpl.class)
public interface TaActFileFeign {

    /**
     * 列表
     */
    @PostMapping("/taactfile/list")
    Result<PageResult<TaActFileRespVo>> list(@RequestBody TaActFileReqVo taActFileReqVo);

    /**
     * 查询
     */
    @PostMapping("/taactfile/query")
    Result<TaActFileRespVo> query(@RequestBody TaActFileReqVo taActFileReqVo);

    /**
     * 新增
     */
    @PostMapping("/taactfile/save")
    Result save(@RequestBody TaActFileReqVo taActFileReqVo);

    /**
     * 更新
     */
    @PostMapping("/taactfile/update")
    Result update(@RequestBody TaActFileReqVo taActFileReqVo);

    /**
     * 删除
     */
    @PostMapping("/taactfile/delete")
    Result delete(@RequestBody TaActFileReqVo taActFileReqVo);

    /**
     * 启用
     */
    @PostMapping("/taactfile/enable")
    Result enable(@RequestBody TaActFileReqVo taActFileReqVo);

    /**
     * 禁用
     */
    @PostMapping("/taactfile/disable")
    Result disable(@RequestBody TaActFileReqVo taActFileReqVo);
}
