package com.biz.crm.activiti.act;

import com.biz.crm.activiti.act.impl.TaActBaseFeignImpl;
import com.biz.crm.activiti.act.impl.TaActProcessFeignImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.activiti.start.req.OptRecordReqVO;
import com.biz.crm.nebular.activiti.start.req.ProcessInfoReqVO;
import com.biz.crm.nebular.activiti.task.req.CopyTaskReqVO;
import com.biz.crm.nebular.activiti.task.req.FormParamQueryReqVO;
import com.biz.crm.nebular.activiti.task.req.TaskQueryReqVO;
import com.biz.crm.nebular.activiti.task.resp.*;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * process feign接口
 *
 * @author jerry7
 * @date 2021-03-11 17:36:45
 */


@FeignClient(url = "${feign.urlip:}", qualifier = "TaActBaseFeign", name = "crm-activiti", path = "activiti", fallbackFactory = TaActProcessFeignImpl.class)
public interface TaActProcessFeign {


    /**
     * 查询待办
     *
     * @param taskReqVO
     * @return
     */
    @PostMapping("/activitiProcessController/findCurrentTask")
     Result<PageResult<TaskRspVO>> findCurrentTask(@RequestBody TaskQueryReqVO taskReqVO);

    /**
     * 查询已办任务
     * @param taskReqVO
     * @return
     */
    @PostMapping("/activitiProcessController/findDoneTask")
    Result<PageResult<TaskRspVO>> findDoneTask(@RequestBody TaskQueryReqVO taskReqVO);


    /**
     * 查询发起任务
     *
     * @param taskReqVO
     * @return
     */
    @PostMapping("/activitiProcessController/findStartTask")
     Result<PageResult<TaskRspVO>> findStartTask(@RequestBody TaskQueryReqVO taskReqVO);

    /**
     * 查询日志
     *
     * @param optRecordReqVO
     * @return
     */
    @PostMapping("/activitiProcessController/getOptRecords")
     Result<PageResult<OptRecordRspVO>> getOptRecords(@RequestBody OptRecordReqVO optRecordReqVO);

    /**
     * 查询流程详情
     *
     * @param processInfoReqVO
     * @return
     */
    @PostMapping("/activitiProcessController/getProcessInfo")
     Result<ProcessInfoRspVO> getProcessInfo(@RequestBody ProcessInfoReqVO processInfoReqVO);

    /**
     * 查询流程日志
     *
     * @param optRecordReqVO
     * @return
     */
    @PostMapping("/activitiProcessController/getOptLogs")
     Result<List<OptLogsRspVO>> getOptLogs(@RequestBody OptRecordReqVO optRecordReqVO);

    /**
     * 查询流程表单参数
     *
     * @param formParamQueryReqVO
     * @return
     */
    @PostMapping("/activitiProcessController/getProcessFormParam")
     Result<FormParamQueryRspVO> getProcessFormParam(@RequestBody FormParamQueryReqVO formParamQueryReqVO);

    /**
     * 查询抄送给我的任务
     *
     * @param copyTaskReqVO
     * @return
     */
    @PostMapping("/activitiProcessController/findMyCopyTask")
     Result<PageResult<CopyTaskRspVO>> findMyCopyTask(@RequestBody CopyTaskReqVO copyTaskReqVO);

    /**
     * 查询抄送任务数量统计
     *
     * @param copyTaskReqVO
     * @return
     */
    @PostMapping("/activitiProcessController/countCopyTask")
     Result<Integer> countCopyTask(@RequestBody CopyTaskReqVO copyTaskReqVO);
}
