package com.biz.crm.activiti.act.impl;

import com.biz.crm.activiti.act.TaActBaseProcessFeign;
import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.activiti.act.req.TaActBaseProcessReqVo;
import com.biz.crm.nebular.activiti.act.resp.TaActBaseProcessRespVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * feign接口熔断类
 *
 * @author jerry7
 * @date 2020-12-05 15:36:45
 */
@Slf4j
@Component
public class TaActBaseProcessFeignImpl extends BaseAbstract implements FallbackFactory<TaActBaseProcessFeign> {

    @Override
    public TaActBaseProcessFeign create(Throwable throwable) {
        log.error("进入熔断", throwable);
        return new TaActBaseProcessFeign() {
            /**
             * 列表
             */
            @Override
            public Result<PageResult<TaActBaseProcessRespVo>> list(TaActBaseProcessReqVo taActBaseProcessReqVo) {
                doBack();
                PageResult<TaActBaseProcessRespVo> build = PageResult.<TaActBaseProcessRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<TaActBaseProcessRespVo> query(String id) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(TaActBaseProcessReqVo taActBaseProcessReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(TaActBaseProcessReqVo taActBaseProcessReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(List<String> ids) {
                return doBack();
            }

            /**
             * 流程关闭
             * @param vo
             * @return
             */
            @Override
            public Result close(TaActBaseProcessReqVo vo) {
                return doBack();
            }

            /**
             * 流程开启
             * @param ids
             * @return
             */
            @Override
            public Result enable(List<String> ids) {
                return doBack();
            }

            /**
             * 流程禁用
             * @param ids
             * @return
             */
            @Override
            public Result disable(List<String> ids) {
                return doBack();
            }

        };
    }
}
