package com.biz.crm.activiti.act.impl;

import com.biz.crm.activiti.act.TaActFileFeign;
import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.activiti.act.req.TaActFileReqVo;
import com.biz.crm.nebular.activiti.act.resp.TaActFileRespVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 工作流文件feign接口熔断类
 *
 * @author jerry7
 * @date 2021-01-14 18:17:13
 */
@Slf4j
@Component
public class TaActFileFeignImpl extends BaseAbstract implements FallbackFactory<TaActFileFeign> {

    @Override
    public TaActFileFeign create(Throwable throwable) {
        log.error("进入熔断", throwable);
        return new TaActFileFeign() {
            /**
             * 列表
             */
            @Override
            public Result<PageResult<TaActFileRespVo>> list(TaActFileReqVo taActFileReqVo) {
                doBack();
                PageResult<TaActFileRespVo> build = PageResult.<TaActFileRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<TaActFileRespVo> query(TaActFileReqVo taActFileReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(TaActFileReqVo taActFileReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(TaActFileReqVo taActFileReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(TaActFileReqVo taActFileReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(TaActFileReqVo taActFileReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(TaActFileReqVo taActFileReqVo) {
                return doBack();
            }
        };
    }
}
