package com.biz.crm.activiti.listener;

import com.biz.crm.activiti.listener.impl.TaListenerProcFeignImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.activiti.listener.req.TaListenerProcReqVo;
import com.biz.crm.nebular.activiti.listener.resp.TaListenerProcRespVo;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * feign接口
 *
 * @author jerry7
 * @date 2020-12-03 09:46:08
 */


@FeignClient(url = "${feign.urlip:}", qualifier = "TaListenerProcFeign", name = "crm-activiti", path = "tpm", fallbackFactory = TaListenerProcFeignImpl.class)
public interface TaListenerProcFeign {

    /**
     * 列表
     */
    @PostMapping("/talistenerproc/list")
    Result<PageResult<TaListenerProcRespVo>> list(@RequestBody TaListenerProcReqVo taListenerProcReqVo);

    /**
     * 查询
     */
    @GetMapping("/talistenerproc/query")
    Result<TaListenerProcRespVo> query(@RequestParam(value = "id", required = false) String id);

    /**
     * 新增
     */
    @PostMapping("/talistenerproc/save")
    Result save(@RequestBody TaListenerProcReqVo taListenerProcReqVo);

    /**
     * 更新
     */
    @PostMapping("/talistenerproc/update")
    Result update(@RequestBody TaListenerProcReqVo taListenerProcReqVo);

    /**
     * 删除
     */
    @PostMapping("/talistenerproc/delete")
    Result delete(@RequestBody List<String> ids);

    /**
     * 启用
     */
    @PostMapping("/talistenerproc/enable")
    Result enable(@RequestBody List<String> ids);

    /**
     * 禁用
     */
    @PostMapping("/talistenerproc/disable")
    Result disable(@RequestBody List<String> ids);
}
