package com.biz.crm.activiti.listener.impl;

import com.biz.crm.activiti.listener.TaListenerFeign;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.nebular.activiti.listener.resp.TaListenerRespVo;
import com.biz.crm.nebular.activiti.listener.req.TaListenerReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;
import java.util.ArrayList;
import java.util.List;

/**
 * feign接口熔断类
 *
 * @author jerry7
 * @date 2020-12-03 09:46:08
 */
@Slf4j
@Component
public class TaListenerFeignImpl extends BaseAbstract implements FallbackFactory<TaListenerFeign> {

    @Override
    public TaListenerFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new TaListenerFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<TaListenerRespVo>> list(TaListenerReqVo taListenerReqVo) {
                doBack();
                PageResult<TaListenerRespVo> build = PageResult.<TaListenerRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<TaListenerRespVo> query(String id) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(TaListenerReqVo taListenerReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(TaListenerReqVo taListenerReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(List<String> ids) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(List<String> ids) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(List<String> ids) {
                return doBack();
            }
        };
    }
}
