package com.biz.crm.dms.orderfeerate;

import com.biz.crm.dms.orderfeerate.impl.OrderFeeRateFeignImpl;
import com.biz.crm.nebular.dms.orderfeerate.*;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.math.BigDecimal;
import java.util.Map;

/** 公告
 * @Description:
 * @Author: heyijiang
 * @Date: 2020/9/27 16:03
 **/
@FeignClient(url ="${feign.urlip:}",qualifier = "orderFeeRateFeign",name="crm-dms",path = "dms",fallbackFactory = OrderFeeRateFeignImpl.class)
public interface OrderFeeRateFeign {

    /**
     * 计算现金折扣最大使用量
     */
    @PostMapping(value = "/api/orderfeerate/calToCash")
    Result<BigDecimal> calToCash(@RequestBody OrderFeeRateCalToCashVo orderFeeRateCalToCashVo);

    /**
     * 计算现金折扣最大使用量
     */
    @PostMapping(value = "/api/orderfeerate/calToCashForObj")
    Result<OrderFeeRateCalToCashResVo> calToCashForObj(@RequestBody OrderFeeRateCalToCashVo orderFeeRateCalToCashVo);

    /**
     * 计算货补最大使用量
     */
    @PostMapping(value = "/api/orderfeerate/calToRep")
    Result<Map<String, BigDecimal>> calToRep(@RequestBody OrderFeeRateCalToRepVo orderFeeRateCalToRepVo);

    /**
     * 计算货补最大使用量（返回对象）
     */
    @PostMapping(value = "/api/orderfeerate/calToRepForObj")
    Result<Map<String, OrderFeeRateCalToResVo>> calToRepForObj(@RequestBody OrderFeeRateCalToRepVo orderFeeRateCalToRepVo);

    /**
     * 计算货补+折扣最大使用量
     */
    @PostMapping(value = "/api/orderfeerate/calToRepAndCash")
    Result<BigDecimal> calToRepAndCash(@RequestBody OrderFeeRateCalToRepAndCashVo orderFeeRateCalToRepAndCashVo);
}
