package com.biz.crm.dms.promotion;

import com.biz.crm.dms.promotion.impl.PromotionPolicyFeignImpl;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyConfigInfo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyConfigInfoQueryVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyInfoVo;
import com.biz.crm.nebular.dms.promotion.policy.req.DmsPromotionPolicyOrderDetailReqVo;
import com.biz.crm.nebular.dms.promotion.policy.resp.PromotionPolicyInfoDataVo;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;


/**
 * 促销政策
 *  @author: luoqi
 *  @Date: 2020-10-19 18:16
 *  @version: V1.0
 *  @Description:
 */
@FeignClient(url ="${feign.urlip:}",qualifier = "promotionPolicyFeign",name="crm-dms",path = "dms",fallbackFactory = PromotionPolicyFeignImpl.class)
public interface PromotionPolicyFeign {


    /**
     * 查询给定的客户在给定的商品下能够享受的促销政策
     *  @author: luoqi
     *  @Date: 2020-10-21 11:20
     *  @version: V1.0
     *  @Description:
     */
    @GetMapping("/promotion/policy/custandproduct")
    Result<List<PromotionPolicyInfoDataVo>> loadPromotionPolicyInfoByCustAndProduct(@RequestParam("custCode")String custCode
            , @RequestParam("productCode")String productCode);


    /**
     *
     * 查询给定的客户在给定的商品列表下能够享受的促销政策
     *  @author: luoqi
     *  @Date: 2020-10-30 14:18
     *  @version: V1.0
     *  @Description:
     */
    @PostMapping("/promotion/policy/custandproducts")
    Result<Map<String, List<PromotionPolicyInfoVo>>> loadPromotionPolicyInfoByCustAndProducts(@RequestParam("custCode")String custCode
            , @RequestBody() List<String> productCodes);
    /**
     *
     * 给定的客户在给定的商品列表下是否能享受促销政策
     *  @author: luoqi
     *  @Date: 2020-10-30 14:18
     *  @version: V1.0
     *  @Description:
     */
    @PostMapping("/promotion/policy/custProductsHasPromotionPolicy")
    Result<Map<String, Boolean>> custProductsHasPromotionPolicy(@RequestParam("custCode")String custCode
            , @RequestBody() List<String> productCodes);

    /**
     * 根据客户查询所有可用促销（商品编码作为key）
     * @param cusCode
     * @return
     */
    @GetMapping(value = "/promotion/policy/findProductMapByCusCode")
    Result<Map<String, List<PromotionPolicyConfigInfo>>> findProductMapByCusCode(@RequestParam("cusCode")String cusCode);

    /**
     * 加载订单下所有商品享受的促销政策和政策规则配置信息
     * @param configInfoQueryVo
     * @return
     */
    @PostMapping(value = "/promotion/policy/loadPromotionPolicyConfigInfoForOrder")
    Result< Map<String, List<PromotionPolicyConfigInfo>> > loadPromotionPolicyConfigInfoForOrder(@RequestBody PromotionPolicyConfigInfoQueryVo configInfoQueryVo);

    /**
     * 锁定促销政策使用明细
     * @param reqVo
     * @return
     */
    @PostMapping("/dmsPromotionPolicyOrderDetailController/lockPromotionPolicyOrderDetail")
    Result<Boolean> lockPromotionPolicyOrderDetail(@RequestBody DmsPromotionPolicyOrderDetailReqVo reqVo);

    /**
     * 提交促销政策使用明细
     * @param orderNo
     * @return
     */
    @PostMapping("/dmsPromotionPolicyOrderDetailController/commitPromotionPolicyOrderDetail")
    Result<Boolean> commitPromotionPolicyOrderDetail(@RequestParam("orderNo") String orderNo);


    /**
     * 释放促销政策使用明细
     * @param orderNo
     * @return
     */
    @PostMapping("/dmsPromotionPolicyOrderDetailController/unlockPromotionPolicyOrderDetail")
    Result<Boolean> unlockPromotionPolicyOrderDetail(@RequestParam("orderNo") String orderNo);


    /**
     * 回滚促销政策使用明细
     * @param orderNo
     * @return
     */
    @PostMapping("/dmsPromotionPolicyOrderDetailController/rollbackPromotionPolicyOrderDetail")
    Result<Boolean> rollbackPromotionPolicyOrderDetail(@RequestParam("orderNo") String orderNo);
}
